/*
 * Definitions for dealing with FMS
 */

#include "lf_fma_comm.h"
#include "libmyri.h"

/*
 * FMS variables
 */
struct fma_fms {
  
  /* list of hostnames to try for FMS connectivity */
  char **host_list;
  int num_hosts;

  int host_index;	/* next to try if nothing open, else current host */
  int connect_tries;	/* attempts since last successful connect */


  int socket;		/* socket for talking to FMS */
  struct lf_channel *chp; /* channel for FMS */

  /* places to hold incoming messages */
  struct lf_fma_msg_header header;
  union lf_fma_message *fms_msgbuf;
  int fms_msgbuf_size;
};

/*
 * definitions
 */

/* time in ms for retrying FMS connection */
#define FMA_FMS_RETRY_TIME 5000

/* If we don't get an FMS after this many tries, go standalone */
#define FMA_FMS_CONNECT_TRY_BEFORE_STANDALONE 5

/*
 * forward references
 */
struct fma_proxy_fma_to_fms;
struct fma_nic_info;

/*
 * prototypes
 */
int fma_set_fms_list(char *);
int fma_init_fms_vars(void);
int fma_init_fms(void);
int fma_fms_myrinet_ready(void);
int fma_send_fma_version(void);
void fma_handle_message(int type, int length, union lf_fma_message *msg);
void fma_fms_report_nic_error(int nic_id, enum myri_error_type error);
void fma_fms_nic_badcrc(int nic_id, int port, int badcrcs);
int fma_fms_send(int type, void *addr, int length, int is_static,
    void (*callback)(void *), void *context);
void fma_enter_fms_mode(void);
void fma_proxy_msg_to_fms(struct fma_nic_info *nip, int port,
  struct fma_proxy_fma_to_fms *pkt);
